/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.world.tree.custom;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.world.tree.BFTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WalnutTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WalnutTrunkPlacer> CODEC = RecordCodecBuilder.create(walnutTrunkPlacerInstance -> WalnutTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)walnutTrunkPlacerInstance).apply((Applicative)walnutTrunkPlacerInstance, WalnutTrunkPlacer::new));

    public WalnutTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return BFTrunkPlacerTypes.WALNUT_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        BlockState stubState;
        BlockPos stubPos;
        BlockState branchState;
        BlockPos branchPos;
        int x;
        WalnutTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)startPos.m_7495_(), (TreeConfiguration)config);
        int mainHeight = random.m_216332_(this.f_70263_, this.f_70264_);
        int northBranchHeight = random.m_216332_(this.f_70265_, mainHeight - 1);
        int eastBranchHeight = random.m_216332_(this.f_70265_, mainHeight - 1);
        int southBranchHeight = random.m_216332_(this.f_70265_, mainHeight - 1);
        int westBranchHeight = random.m_216332_(this.f_70265_, mainHeight - 1);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < mainHeight; ++i) {
            this.m_226187_(world, replacer, random, startPos.m_6630_(i), config);
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.m_6630_(northBranchHeight).m_5484_(Direction.NORTH, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, true));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.m_6630_(eastBranchHeight).m_5484_(Direction.EAST, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.m_6630_(southBranchHeight).m_5484_(Direction.SOUTH, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        for (x = 1; x < 3; ++x) {
            branchPos = startPos.m_6630_(westBranchHeight).m_5484_(Direction.WEST, x);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
            replacer.accept(branchPos, branchState);
            list.add(new FoliagePlacer.FoliageAttachment(branchPos, 0, false));
        }
        this.m_226187_(world, replacer, random, startPos.m_6630_(mainHeight), config);
        int stubDirChance = random.m_216332_(1, 4);
        if (stubDirChance == 1) {
            stubPos = startPos.m_6630_(random.m_216332_(2, 3)).m_5484_(Direction.NORTH, 1);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
            replacer.accept(stubPos, branchState);
        }
        if (stubDirChance == 2) {
            stubPos = startPos.m_6630_(random.m_216332_(2, 3)).m_5484_(Direction.EAST, 1);
            stubState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
            replacer.accept(stubPos, stubState);
        }
        if (stubDirChance == 3) {
            stubPos = startPos.m_6630_(random.m_216332_(2, 3)).m_5484_(Direction.SOUTH, 1);
            branchState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
            replacer.accept(stubPos, branchState);
        }
        if (stubDirChance == 4) {
            stubPos = startPos.m_6630_(random.m_216332_(2, 3)).m_5484_(Direction.WEST, 1);
            stubState = (BlockState)BFBlocks.WALNUT_LOG.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
            replacer.accept(stubPos, stubState);
        }
        list.add(new FoliagePlacer.FoliageAttachment(startPos.m_6630_(mainHeight), 0, false));
        return list;
    }
}

